$TITLE: 26 COUNTRIE INSIDE MONEY STRUCTURE: BY CHUNDING LI
OPTION NLP=CONOPT

SET
R    COUNTRIES    /AUSTRALIA,BAHRAIN,BRAZIL,BRUNEI,CANADA,CHILE,CHINA,EU,INDIA,INDONESIA,JAPAN,KOREA,
                   KUWAIT,MALAYSIA,MEXICO,NEWZEALAND,PERU,PHILIPPINE,QATAR,RUSSIAN,ARABIA,SINGAPORE,
                   THAILAND,US,VIETNAM,ROW/
G    SECTORS      /TRADABLE, NONTRADABLE/
F    FACTORS      /K,L/
;
ALIAS (R,RR),(R,RRR),(G,GG),(F,FF);

PARAMETERS
PRN1(R,G)         TOTAL PRODUCTION
FACDEM1(R,G,F)    FACTOR DEMAND IN PRODUCTION
ELASP0(R,G)       FACTOR ELASTICITY OF SUBSTITUTION
GROWTH(R)         ANNUAL GROWTH RARE

TGDEM1(R)         ARMINGTON TRADABLE COMPOSITE GOODS DEMAND
/AUSTRALIA           364.1
 BAHRAIN             25.8
 BRAZIL              367.4
 BRUNEI              6.3
 CANADA              763.6
 CHILE               98.9
 CHINA               6159
 EU                  4376.6
 INDIA               1307.9
 INDONESIA           555.7
 JAPAN               1516.3
 KOREA               731.2
 KUWAIT              48.4
 MALAYSIA            234.3
 MEXICO              632.3
 NEWZEALAND          66.8
 PERU                80.5
 PHILIPPINE          180.0
 QATAR               64.7
 RUSSIAN             372.2
 ARABIA              247.3
 SINGAPORE           380.6
 THAILAND            284.3
 US                  4870
 VIETNAM             303.1
 ROW                 8205.0/,

GROWTH(R)         ANNUAL GROWTH RARE
/AUSTRALIA           0.0206
 BAHRAIN             0.0126
 BRAZIL              0.0146
 BRUNEI              0.0045
 CANADA              0.0149
 CHILE               0.0219
 CHINA               0.0491
 EU                  0.014
 INDIA               0.0358
 INDONESIA           0.0299
 JAPAN               -0.0026
 KOREA               0.0211
 KUWAIT              0.0015
 MALAYSIA            0.0273
 MEXICO              0.002
 NEWZEALAND          0.0245
 PERU                0.0187
 PHILIPPINE          0.0247
 QATAR               0.0074
 RUSSIAN             0.0077
 ARABIA              0.0209
 SINGAPORE           0.0249
 THAILAND            0.0003
 US                  0.0185
 VIETNAM             0.052
 ROW                 0.0223/,
GDEM1(R,RR)       TRADABLE GOODS DEMAND
NGDEM1(R)         NONTRADABLE GOODS DEMAND
/AUSTRALIA           971.9
 BAHRAIN             10.1
 BRAZIL              1391.6
 BRUNEI              2.3
 CANADA              868.3
 CHILE               171.6
 CHINA               6738.8
 EU                  13946.6
 INDIA               1521.0
 INDONESIA           428.3
 JAPAN               3281.5
 KOREA               783.0
 KUWAIT              43.1
 MALAYSIA            66.9
 MEXICO              490.7
 NEWZEALAND          121.8
 PERU                112.3
 PHILIPPINE          144.9
 QATAR               62.5
 RUSSIAN             1015.7
 ARABIA              342.3
 SINGAPORE           174.9
 THAILAND            197.7
 US                  16160.7
 VIETNAM             71.7
 ROW                 1508.3/,

MONEY1(R)         INSIDE MONEY
/AUSTRALIA           1017.3
 BAHRAIN             993.7
 BRAZIL              1058.7
 BRUNEI              1002.4
 CANADA              990.5
 CHILE               1001.3
 CHINA               1359.3
 EU                  973.1
 INDIA               814.9
 INDONESIA           991.5
 JAPAN               990.0
 KOREA               1069.6
 KUWAIT              1036
 MALAYSIA            1029.9
 MEXICO              986.4
 NEWZEALAND          996.1
 PERU                1004.8
 PHILIPPINE          952.4
 QATAR               1052.6
 RUSSIAN             1211.3
 ARABIA              1159.3
 SINGAPORE           1041.2
 THAILAND            1003.3
 US                  53.9
 VIETNAM             1006.8
 ROW                 1203.7/,

ELASC10(R)         ELASTICITY OF ARMINGTON CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ELASC20(R)         ELASTICITY OF GOODS CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ENDW(R,F)         ENDOWMENT OF FACTORS BY INDIVIDUAL
TARIFF(R,RR)      IMPORT TARIFF
NTARIFF(R,RR)     NON-TARIFF BARRIER
RTA(R,RR)         PARAMETER OF TARIFF USED FOR CALCULATING FTA CHANGE
FTA(R,RR)         JOINT FTA EFFECT
WAR(R,RR)         CHINA-US TRADE WAR
;

TABLE PRN1(R,G)
                    TRADABLE          NONTRADABLE
AUSTRALIA           381.4             1052.5
BAHRAIN             19.5              18.2
BRAZIL              426.1             1442.5
BRUNEI              8.7               4.9
CANADA              754.1             959.2
CHILE               100.2             198.0
CHINA               6518.3            7089.9
EU                  4349.7            14398.9
INDIA               1122.8            1595.9
INDONESIA           547.2             495
JAPAN               1506.3            3465
KOREA               800.8             818.6
KUWAIT              84.4              56.2
MALAYSIA            264.2             94.4
MEXICO              618.7             602.0
NEWZEALAND          62.9              142.0
PERU                85.3              136.8
PHILIPPINE          132.4             198.5
QATAR               117.3             74.1
RUSSIAN             583.5             1074.1
ARABIA              406.6             379.9
SINGAPORE           421.8             242.4
THAILAND            287.6             217.3
US                  3923.9            16620.4
VIETNAM             309.9             115.3
ROW                 8408.7            2655.4  ;

TABLE FACDEM1(R,G,F)
                                     K                L
AUSTRALIA.TRADABLE                   91.5             289.9
AUSTRALIA.NONTRADABLE                252.6            799.9
BAHRAIN.TRADABLE                     6.3              13.2
BAHRAIN.NONTRADABLE                  5.8              12.4
BRAZIL.TRADABLE                      63.9             362.2
BRAZIL.NONTRADABLE                   216.4            1226.1
BRUNEI.TRADABLE                      3.5              5.2
BRUNEI.NONTRADABLE                   2.1              2.8
CANADA.TRADABLE                      173.5            580.6
CANADA.NONTRADABLE                   220.6            738.6
CHILE.TRADABLE                       23.1             77.1
CHILE.NONTRADABLE                    45.5             152.5
CHINA.TRADABLE                       2868             3650.3
CHINA.NONTRADABLE                    3119.6           3970.3
EU.TRADABLE                          913.4            3436.3
EU.NONTRADABLE                       3023.8           11375.1
INDIA.TRADABLE                       348.1            774.7
INDIA.NONTRADABLE                    494.7            1101.2
INDONESIA.TRADABLE                   191.5            355.7
INDONESIA.NONTRADABLE                173.3            321.7
JAPAN.TRADABLE                       361.5            1144.8
JAPAN.NONTRADABLE                    831.6            2633.4
KOREA.TRADABLE                       240.2            560.6
KOREA.NONTRADABLE                    245.6            573
KUWAIT.TRADABLE                      21.1             63.3
KUWAIT.NONTRADABLE                   14.1             42.1
MALAYSIA.TRADABLE                    63.4             200.8
MALAYSIA.NONTRADABLE                 22.7             71.7
MEXICO.TRADABLE                      142.3            476.4
MEXICO.NONTRADABLE                   138.5            463.5
NEWZEALAND.TRADABLE                  15.1             47.8
NEWZEALAND.NONTRADABLE               34.1             107.9
PERU.TRADABLE                        17.9             67.4
PERU.NONTRADABLE                     28.7             108.1
PHILIPPINE.TRADABLE                  35.7             96.7
PHILIPPINE.NONTRADABLE               53.6             144.9
QATAR.TRADABLE                       50.4             66.9
QATAR.NONTRADABLE                    31.9             42.2
RUSSIAN.TRADABLE                     134.1            449.4
RUSSIAN.NONTRADABLE                  247.1            827.0
ARABIA.TRADABLE                      97.6             309.0
ARABIA.NONTRADABLE                   91.2             288.7
SINGAPORE.TRADABLE                   113.9            307.9
SINGAPORE.NONTRADABLE                65.4             177.0
THAILAND.TRADABLE                    71.9             215.7
THAILAND.NONTRADABLE                 54.3             163.0
US.TRADABLE                          1824             2099.9
US.NONTRADABLE                       2490.3           14130.1
VIETNAM.TRADABLE                     83.7             226.2
VIETNAM.NONTRADABLE                  31.1             84.2
ROW.TRADABLE                         2018.1           6390.6
ROW.NONTRADABLE                      637.3            2018.1   ;


TABLE ELASP0(R,G)
                    TRADABLE           NONTRADABLE
AUSTRALIA           1.0                1.0
BAHRAIN             1.0                1.0
BRAZIL              1.0                1.0
BRUNEI              1.0                1.0
CANADA              1.0                1.0
CHILE               1.0                1.0
CHINA               1.0                1.0
EU                  1.0                1.0
INDIA               1.0                1.0
INDONESIA           1.0                1.0
JAPAN               1.0                1.0
KOREA               1.0                1.0
KUWAIT              1.0                1.0
MALAYSIA            1.0                1.0
MEXICO              1.0                1.0
NEWZEALAND          1.0                1.0
PERU                1.0                1.0
PHILIPPINE          1.0                1.0
QATAR               1.0                1.0
RUSSIAN             1.0                1.0
ARABIA              1.0                1.0
SINGAPORE           1.0                1.0
THAILAND            1.0                1.0
US                  1.0                1.0
VIETNAM             1.0                1.0
ROW                 1.0                1.0  ;

TABLE GDEM1(R,RR)

                    AUSTRALIA   BAHRAIN   BRAZIL    BRUNEI   CANADA    CHILE    CHINA      EU       INDIA   INDONESIA   JAPAN     KOREA     KUWAIT   MALAYSIA   MEXICO
AUSTRALIA           128.6       0.075     0.664     0.582    1.703     0.372    57.699     41.871   3.846   2.801       4.242     10.182    0.042    8.311      1.001
BAHRAIN             0.946       5.2       0.673     0        0.186     0.103    1.878      2.548    0.769   0.087       0.795     0.251     0.112    0.137      0.074
BRAZIL              1.125       0.117     186.2     0.001    2.252     3.382    34.731     38.759   3.663   1.331       4.356     5.381     0.213    1.531      4.369
BRUNEI              0.047       0         0.001     2.1      0.007     0.002    1.641      0.721    0.069   0.072       0.001     0.097     0        0.451      0.004
CANADA              1.619       0.028     4.247     0.006    303.7     1.396    58.319     48.177   3.958   1.358       12.997    7.295     0.031    2.302      14.034
CHILE               0.258       0.001     6.678     0.001    0.889     24.7     17.504     11.612   0.977   0.194       2.491     1.871     0        0.247      2.059
CHINA               105.083     0.151     77.142    0.248    28.354    26.999   4024.1     245.173  18.851  27.127      180.402   204.566   15.359   34.413     7.169
EU                  13.169      1.695     37.131    0.152    36.031    9.562    465.022    2041.5   53.978  19.516      82.859    60.026    3.875    30.169     30.512
INDIA               14.081      0.585     4.621     0.433    3.467     1.669    73.605     52.755   800.3   13.725      12.537    16.388    7.805    8.991      1.378
INDONESIA           5.826       0.069     1.803     0.021    1.841     0.115    45.537     11.137   5.017   367.0       17.977    9.089     0.267    8.603      0.287
JAPAN               45.681      1.241     6.886     2.269    11.731    7.409    173.612    74.271   5.498   19.479      768.1     32.112    7.248    17.109     3.275
KOREA               20.717      0.563     3.908     0.611    5.751     4.475    106.488    57.541   5.885   9.532       54.603    196.0     12.794   8.344      2.277
KUWAIT              0           0.771     0.291     0.001    0.243     0.032    5.979      6.589    1.861   0.228       2.104     1.408     12.5     0.307      0.209
MALAYSIA            5.345       0.109     1.965     0.433    0.809     0.125    43.316     16.562   6.559   9.437       15.729    9.629     0.478    16.900     0.368
MEXICO              0.328       0.0445    6.508     0.001    10.752    1.667    83.509     45.984   5.232   1.587       18.189    16.725    0.017    2.073      168.0
NEWZEALAND          5.019       0.009     0.126     0.001    0.487     0.089    8.643      6.601    0.509   0.643       3.036     2.004     0.009    1.447      0.317
PERU                0.116       0.001     2.415     0        0.703     1.367    10.059     4.349    0.902   0.286       1.054     0.972     0.001    0.234      1.647
PHILIPPINE          1.538       0.024     0.642     0.036    0.791     0.041    22.579     8.932    1.784   6.789       11.397    11.503    1.394    4.285      0.154
QATAR               0.703       0.009     0.321     0        0.169     0.014    3.916      12.441   1.991   0.149       1.383     0.588     0.327    0.322      0.192
RUSSIAN             0.671       0.007     2.471     0        0.746     1.058    52.218     99.729   3.225   1.715       8.822     7.009     0        1.627      0.938
ARABIA              0.649       1.555     2.309     0.001    1.714     0.148    22.244     34.641   5.685   1.578       5.474     4.301     0.417    1.167      0.745
SINGAPORE           5.457       0.124     1.555     0.525    1.542     0.091    49.634     43.516   7.262   12.992      22.149    14.193    4.073    34.471     2.346
THAILAND            5.935       0.166     2.064     0.859    0.981     0.452    49.953     17.522   4.863   8.045       35.259    8.847     0.929    14.062     0.653
US                  10.209      1.025     32.286    0.102    325.684   12.201   563.203    472.782  56.444  18.472      145.902   76.201    2.126    22.525     344.661
VIETNAM             3.201       0.013     1.838     0.052    0.799     0.283    58.533     12.971   3.955   3.656       16.917    46.943    0.288    8.475      0.788
ROW                 5.077       5.918     41.355    0.265    12.768    2.448    484.378    941.016  119.717 19.401      77.525    57.219    14.095   35.697     31.243

+
                    NEWZEALAND  PERU    PHILIPPINE  QATAR    RUSSIAN   ARABIA   SINGAPORE  THAILAND     US        VIETNAM    ROW
AUSTRALIA           6.057       0.256    0.551      0.355    0.181     0.476    8.822      11.524       24.666    3.966      45.255
BAHRAIN             0.053       0.002    0.029      0        0.099     6.814    0.111      0.286        1.206     0.173      3.268
BRAZIL              0.061       1.811    0.271      0.273    3.374     2.319    0.646      1.651        29.351    2.059      38.173
BRUNEI              0.005       0        0.014      0.003    0.001     0.002    0.374      0.109        0.361     0.017      0.201
CANADA              0.579       1.099    1.121      0.069    1.141     2.939    0.974      2.749        235.118   3.014      55.33
CHILE               0.138       1.156    0.052      0        0.071     0.033    0.101      0.987        13.999    0.768      12.113
CHINA               11.079      15.213   8.698      9.091    58.887    45.899   33.638     44.919       156.004   41.366     739.069
EU                  4.075       7.183    9.359      8.525    179.625   36.076   23.509     26.886       313.541   45.089     837.535
INDIA               0.633       2.454    0.615      10.587   6.801     28.431   14.437     7.647        32.715    6.544      184.696
INDONESIA           0.808       0.056    0.958      1.411    1.551     4.911    21.439     10.953       10.212    3.534      25.278
JAPAN               2.651       2.454    9.473      14.856   15.587    33.775   9.733      25.058       83.571    18.834     124.387
KOREA               1.379       2.474    2.542      16.294   17.504    26.336   7.974      5.582        59.081    18.241     84.304
KUWAIT              0.068       0.004    0.071      0.051    0.229     2.042    0.151      0.409        3.104     0.527      9.221
MALAYSIA            0.826       0.112    1.929      0.676    1.157     4.433    25.474     12.035       16.094    4.065      39.735
MEXICO              0.291       0.474    0.606      0.059    1.969     0.089    1.669      6.359        216.271   2.239      41.658
NEWZEALAND          23.1        0.039    0.099      0.055    0.166     0.387    1.476      1.921        4.425     0.639      5.553
PERU                0.133       37.4     0.058      0.019    0.438     0.183    0.068      0.401        9.174     0.353      8.167
PHILIPPINE          0.518       0.108    64.9       0.389    1.301     1.892    6.311      7.948        8.297     3.465      12.982
QATAR               0.032       0.072    0.072      33.0     0.282     0.015    0.214      0.367        6.177     0.258      1.686
RUSSIAN             0.136       0.182    0.417      0.036    132.0     0.292    0.869      1.856        12.691    2.446      41.039
ARABIA              0.476       0.011    0.257      0        1.221     112.1    1.289      1.993        18.041    1.585      27.699
SINGAPORE           0.808       0.013    4.234      6.784    5.761     12.631   10.1       8.291        42.103    3.467      86.478
THAILAND            0.719       0.135    2.717      3.532    2.395     7.316    7.696      35.1         15.201    5.268      53.631
US                  4.364       8.272    10.551     1.619    21.596    24.616   26.879     33.027       2258.6    47.581     349.072
VIETNAM             0.502       0.117    1.158      0.138    1.392     1.309    5.319      10.702       9.343     66.2       48.208
ROW                 3.409       4.203    11.648     9.478    128.771   51.284   212.527    28.84        344.554   28.202     612.6   ;

TABLE ENDW(R,F)
                     K                L
AUSTRALIA            344.1            1089.8
BAHRAIN              12.1             25.6
BRAZIL               280.3            1588.3
BRUNEI               5.6              8.0
CANADA               394.1            1319.2
CHILE                68.6             229.6
CHINA                5987.6           7620.6
EU                   3937.2           14811.4
INDIA                842.8            1875.9
INDONESIA            364.8            677.4
JAPAN                1193.1           3778.2
KOREA                485.8            1133.6
KUWAIT               35.2             105.4
MALAYSIA             86.1             272.5
MEXICO               280.8            939.9
NEWZEALAND           49.2             155.7
PERU                 46.6             175.5
PHILIPPINE           89.3             241.6
QATAR                82.3             109.1
RUSSIAN              381.2            1276.4
ARABIA               188.8            597.7
SINGAPORE            179.3            484.9
THAILAND             126.2            378.7
US                   4314.3           16230.0
VIETNAM              114.8            310.4
ROW                  2655.4           8408.7   ;

TABLE TARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.025    0.025   0.025   0.025   0.025  0.025  0.025  0.025  0.025      0.025  0.025  0.025   0.025     0.025
BAHRAIN             0.053      0        0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
BRAZIL              0.134      0.134    0       0.134   0.134   0.134  0.134  0.134  0.134  0.134      0.134  0.134  0.134   0.134     0.134
BRUNEI              0.321      0.321    0.321   0       0.321   0.321  0.321  0.321  0.321  0.321      0.321  0.321  0.321   0.321     0.321
CANADA              0.040      0.040    0.040   0.040   0       0.040  0.040  0.040  0.040  0.040      0.040  0.040  0.040   0.040     0.040
CHILE               0.060      0.060    0.060   0.060   0.060   0      0.060  0.060  0.060  0.060      0.060  0.060  0.060   0.060     0.060
CHINA               0.098      0.098    0.098   0.098   0.098   0.098  0      0.098  0.098  0.098      0.098  0.098  0.098   0.098     0.098
EU                  0.052      0.052    0.052   0.052   0.052   0.052  0.052  0      0.052  0.052      0.052  0.052  0.052   0.052     0.052
INDIA               0.171      0.171    0.171   0.171   0.171   0.171  0.171  0.171  0      0.171      0.171  0.171  0.171   0.171     0.171
INDONESIA           0.081      0.081    0.081   0.081   0.081   0.081  0.081  0.081  0.081  0          0.081  0.081  0.081   0.081     0.081
JAPAN               0.044      0.044    0.044   0.044   0.044   0.044  0.044  0.044  0.044  0.044      0      0.044  0.044   0.044     0.044
KOREA               0.137      0.137    0.137   0.137   0.137   0.137  0.137  0.137  0.137  0.137      0.137  0      0.137   0.137     0.137
KUWAIT              0.047      0.047    0.047   0.047   0.047   0.047  0.047  0.047  0.047  0.047      0.047  0.047  0       0.047     0.047
MALAYSIA            0.056      0.056    0.056   0.056   0.056   0.056  0.056  0.056  0.056  0.056      0.056  0.056  0.056   0         0.056
MEXICO              0.070      0.070    0.070   0.070   0.070   0.070  0.070  0.070  0.070  0.070      0.070  0.070  0.070   0.070     0
NEWZEALAND          0.020      0.020    0.020   0.020   0.020   0.020  0.020  0.020  0.020  0.020      0.020  0.020  0.020   0.020     0.020
PERU                0.024      0.024    0.024   0.024   0.024   0.024  0.024  0.024  0.024  0.024      0.024  0.024  0.024   0.024     0.024
PHILIPPINE          0.062      0.062    0.062   0.062   0.062   0.062  0.062  0.062  0.062  0.062      0.062  0.062  0.062   0.062     0.062
QATAR               0.048      0.048    0.048   0.048   0.048   0.048  0.048  0.048  0.048  0.048      0.048  0.048  0.048   0.048     0.048
RUSSIAN             0.068      0.068    0.068   0.068   0.068   0.068  0.068  0.068  0.068  0.068      0.068  0.068  0.068   0.068     0.068
ARABIA              0.053      0.053    0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
SINGAPORE           0.001      0.001    0.001   0.001   0.001   0.001  0.001  0.001  0.001  0.001      0.001  0.001  0.001   0.001     0.001
THAILAND            0.096      0.096    0.096   0.096   0.096   0.096  0.096  0.096  0.096  0.096      0.096  0.096  0.096   0.096     0.096
US                  0.035      0.035    0.035   0.035   0.035   0.035  0.035  0.035  0.035  0.035      0.035  0.035  0.035   0.035     0.035
VIETNAM             0.095      0.095    0.095   0.095   0.095   0.095  0.095  0.095  0.095  0.095      0.095  0.095  0.095   0.095     0.095
ROW                 0.061      0.061    0.061   0.061   0.061   0.061  0.061  0.061  0.061  0.061      0.061  0.061  0.061   0.061     0.061

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR    RUSSIAN  ARABIA  SINGAPORE  THAILAND   US      VIETNAM  ROW
AUSTRALIA           0.025       0.025    0.025       0.025    0.025    0.025   0.025      0.025      0.025   0.025    0.025
BAHRAIN             0.053       0.053    0.053       0.053    0.053    0.053   0.053      0.053      0.053   0.053    0.053
BRAZIL              0.134       0.134    0.134       0.134    0.134    0.134   0.134      0.134      0.134   0.134    0.134
BRUNEI              0.321       0.321    0.321       0.321    0.321    0.321   0.321      0.321      0.321   0.321    0.321
CANADA              0.040       0.040    0.040       0.040    0.040    0.040   0.040      0.040      0.040   0.040    0.040
CHILE               0.060       0.060    0.060       0.060    0.060    0.060   0.060      0.060      0.060   0.060    0.060
CHINA               0.098       0.098    0.098       0.098    0.098    0.098   0.098      0.098      0.098   0.098    0.098
EU                  0.052       0.052    0.052       0.052    0.052    0.052   0.052      0.052      0.052   0.052    0.052
INDIA               0.171       0.171    0.171       0.171    0.171    0.171   0.171      0.171      0.171   0.171    0.171
INDONESIA           0.081       0.081    0.081       0.081    0.081    0.081   0.081      0.081      0.081   0.081    0.081
JAPAN               0.044       0.044    0.044       0.044    0.044    0.044   0.044      0.044      0.044   0.044    0.044
KOREA               0.137       0.137    0.137       0.137    0.137    0.137   0.137      0.137      0.137   0.137    0.137
KUWAIT              0.047       0.047    0.047       0.047    0.047    0.047   0.047      0.047      0.047   0.047    0.047
MALAYSIA            0.056       0.056    0.056       0.056    0.056    0.056   0.056      0.056      0.056   0.056    0.056
MEXICO              0.070       0.070    0.070       0.070    0.070    0.070   0.070      0.070      0.070   0.070    0.070
NEWZEALAND          0           0.020    0.020       0.020    0.020    0.020   0.020      0.020      0.020   0.020    0.020
PERU                0.024       0        0.024       0.024    0.024    0.024   0.024      0.024      0.024   0.024    0.024
PHILIPPINE          0.062       0.062    0           0.062    0.062    0.062   0.062      0.062      0.062   0.062    0.062
QATAR               0.048       0.048    0.048       0        0.048    0.048   0.048      0.048      0.048   0.048    0.048
RUSSIAN             0.068       0.068    0.068       0.068    0        0.068   0.068      0.068      0.068   0.068    0.068
ARABIA              0.053       0.053    0.053       0.053    0.053    0       0.053      0.053      0.053   0.053    0.053
SINGAPORE           0.001       0.001    0.001       0.001    0.001    0.001   0          0.001      0.001   0.001    0.001
THAILAND            0.096       0.096    0.096       0.096    0.096    0.096   0.096      0          0.096   0.096    0.096
US                  0.035       0.035    0.035       0.035    0.035    0.035   0.035      0.035      0       0.035    0.035
VIETNAM             0.095       0.095    0.095       0.095    0.095    0.095   0.095      0.095      0.095   0        0.095
ROW                 0.061       0.061    0.061       0.061    0.061    0.061   0.061      0.061      0.061   0.061    0       ;

TABLE NTARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.855    1.045   0.622   0.692   0.785  0.292  0.508  0.523  0.592      0.354  0.227  0.915   0.225     0.836
BAHRAIN             0.827      0        0.845   0.006   0.897   0.006  0.668  0.513  0.410  1.020      0.572  0.385  0.474   0.435     1.227
BRAZIL              0.936      0.764    0       0.001   0.487   0.321  0.277  0.310  0.453  0.740      0.492  0.258  0.653   0.364     0.409
BRUNEI              0.644      0.251    0.251   0       0.251   0.251  0.560  1.059  0.251  0.631      0.522  0.344  0.251   0.261     0.251
CANADA              0.677      0.910    0.581   0.002   0       0.529  0.333  0.321  0.499  0.709      0.374  0.287  0.926   0.389     0.237
CHILE               0.750      0.000    0.395   0.000   0.509   0      0.320  0.421  0.509  1.057      0.478  0.252  0.000   0.588     0.451
CHINA               0.219      0.623    0.313   0.465   0.275   0.282  0      0.206  0.312  0.363      0.156  0.035  0.427   0.034     0.379
EU                  0.481      0.514    0.392   1.010   0.309   0.429  0.252  0      0.318  0.607      0.369  0.203  0.449   0.220     0.382
INDIA               0.377      0.292    0.416   0.036   0.368   0.398  0.239  0.199  0      0.290      0.343  0.131  0.148   0.027     0.381
INDONESIA           0.536      0.992    0.793   0.553   0.668   1.036  0.380  0.578  0.380  0          0.346  0.228  0.762   0.112     0.917
JAPAN               0.335      0.581    0.582   0.481   0.370   0.494  0.210  0.377  0.470  0.383      0      0.101  0.376   0.131     0.504
KOREA               0.115      0.301    0.255   0.210   0.190   0.175  0.002  0.118  0.165  0.172      0.008  0      0.075   0.026     0.219
KUWAIT              0.893      0.480    0.740   0.000   0.919   0.000  0.478  0.454  0.272  0.796      0.373  0.165  0       0.614     0.000
MALAYSIA            0.194      0.432    0.442   0.208   0.373   0.592  0.076  0.216  0.142  0.137      0.119  0.007  0.605   0         0.519
MEXICO              0.791      1.210    0.473   0.009   0.207   0.441  0.407  0.364  0.482  0.928      0.478  0.286  0.009   0.505     0
NEWZEALAND          0.280      0.000    1.188   0.602   0.688   1.008  0.494  0.588  0.746  0.772      0.546  0.388  0.000   0.312     0.888
PERU                1.376      0.010    0.655   0.010   0.590   0.445  0.571  0.672  0.778  1.402      0.753  0.468  0.010   0.901     0.671
PHILIPPINE          0.714      0.001    0.891   0.880   0.645   1.081  0.426  0.612  0.711  0.642      0.399  0.242  1.201   0.263     0.819
QATAR               0.651      0.306    0.668   0.001   0.749   1.084  0.423  0.308  0.227  0.701      0.225  0.079  0.585   0.311     0.880
RUSSIAN             0.973      0.029    0.699   0.029   0.754   1.047  0.341  0.141  0.593  0.837      0.414  0.237  0.029   0.560     0.867
ARABIA              0.877      0.226    0.574   0.005   0.567   1.113  0.309  0.308  0.166  0.558      0.300  0.091  0.494   0.367     0.839
SINGAPORE           0.191      0.379    0.502   0.208   0.427   0.818  0.129  0.199  0.129  0.094      0.198  0.012  0.812   0.161     0.482
THAILAND            0.057      0.168    0.285   0.115   0.228   0.346  0.048  0.097  0.081  0.074      0.042  0.049  0.453   0.019     0.255
US                  0.528      0.632    0.418   1.061   0.001   0.376  0.250  0.249  0.367  0.604      0.298  0.177  0.470   0.217     0.036
VIETNAM             0.254      0.000    0.440   0.388   0.351   0.477  0.065  0.205  0.155  0.306      0.101  0.014  0.656   0.033     0.533
ROW                 0.160      0.027    0.121   0.476   0.178   0.221  0.659  0.663  0.724  0.461      0.074  0.056  0.122   0.070     0.185

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR   RUSSIAN  ARABIA  SINGAPORE  THAILAND    US      VIETNAM  ROW
AUSTRALIA           0.275       1.375    0.751       0.674   1.016    0.905   0.166      0.128       0.538   0.324    0.196
BAHRAIN             0.006       0.006    0.006       0.301   0.006    0.226   0.326      0.211       0.614   0.094    0.135
BRAZIL              1.074       0.545    0.819       0.582   0.633    0.493   0.368      0.247       0.319   0.401    0.048
BRUNEI              0.619       0.251    0.939       0.251   0.251    0.251   0.305      0.308       1.093   0.480    0.534
CANADA              0.668       0.574    0.667       0.757   0.782    0.580   0.387      0.284       0.084   0.406    0.199
CHILE               0.968       0.409    1.083       1.072   1.055    1.106   0.758      0.382       0.351   0.512    0.222
CHINA               0.416       0.497    0.390       0.373   0.311    0.264   0.031      0.086       0.187   0.062    0.122
EU                  0.556       0.644    0.622       0.304   0.157    0.309   0.147      0.141       0.232   0.248    0.072
INDIA               0.595       0.631    0.602       0.104   0.490    0.048   0.012      0.006       0.231   0.079    0.048
INDONESIA           0.711       1.345    0.623       0.668   0.824    0.530   0.013      0.089       0.558   0.320    0.441
JAPAN               0.522       0.733    0.417       0.229   0.438    0.309   0.154      0.094       0.289   0.152    0.091
KOREA               0.271       0.355    0.167       0.020   0.168    0.007   0.075      0.008       0.075   0.072    0.080
KUWAIT              0.000       0.000    1.216       0.586   0.000    0.500   0.765      0.502       0.458   0.704    0.136
MALAYSIA            0.276       0.869    0.269       0.303   0.572    0.364   0.105      0.059       0.196   0.172    0.075
MEXICO              0.838       0.625    0.811       0.858   0.865    0.822   0.412      0.281       0.101   0.558    0.176
NEWZEALAND          0           1.165    0.763       0.706   0.927    0.645   0.274      0.259       0.599   0.452    0.296
PERU                1.161       0.000    1.277       0.010   1.151    1.495   1.115      0.549       0.529   1.086    0.354
PHILIPPINE          0.721       1.239    0.000       0.713   1.030    0.824   0.152      0.146       0.551   0.422    0.655
QATAR               0.678       0.001    0.727       0.000   1.185    0.365   0.070      0.078       0.493   0.411    0.160
RUSSIAN             0.879       1.107    1.024       1.165   0.000    0.961   0.497      0.345       0.512   0.379    0.060
ARABIA              0.612       1.466    0.833       0.360   0.976    0.000   0.260      0.272       0.313   0.368    0.099
SINGAPORE           0.294       1.139    0.214       0.118   0.565    0.313   0.000      0.128       0.196   0.008    0.168
THAILAND            0.183       0.477    0.112       0.030   0.317    0.229   0.032      0.000       0.085   0.137    0.093
US                  0.584       0.518    0.578       0.506   0.545    0.331   0.161      0.146       0.000   0.265    0.040
VIETNAM             0.377       1.015    0.389       0.364   0.352    0.326   0.013      0.038       0.205   0.000    0.539
ROW                 0.255       0.317    0.656       0.147   0.067    0.091   0.107      0.048       0.047   0.573    0.000  ;

TABLE RTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       1       1       1      1      1     1      1          1      1      1       1         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              1          1        1       0       1       1      1      1     1      1          1      1      1       1         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               1          1        1       1       1       1      0      1     1      1          1      1      1       1         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               1          1        1       1       1       1      1      1     0      1          1      1      1       1         1
INDONESIA           1          1        1       1       1       1      1      1     1      0          1      1      1       1         1
JAPAN               1          1        1       1       1       1      1      1     1      1          0      1      1       1         1
KOREA               1          1        1       1       1       1      1      1     1      1          1      0      1       1         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            1          1        1       1       1       1      1      1     1      1          1      1      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
THAILAND            1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           1           1     1           1      1         1       1          1         1   1        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              1           1     1           1      1         1       1          1         1   1        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               1           1     1           1      1         1       1          1         1   1        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               1           1     1           1      1         1       1          1         1   1        1
INDONESIA           1           1     1           1      1         1       1          1         1   1        1
JAPAN               1           1     1           1      1         1       1          1         1   1        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            1           1     1           1      1         1       1          1         1   1        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     1           1      1         1       1          1         1   1        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          1           1     0           1      1         1       1          1         1   1        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           1           1     1           1      1         1       0          1         1   1        1
THAILAND            1           1     1           1      1         1       1          0         1   1        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             1           1     1           1      1         1       1          1         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0  ;


TABLE FTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
INDONESIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
JAPAN               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KOREA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
THAILAND            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           1     0           1      1         1       0          0         1   0        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              0           1     0           1      1         1       0          0         1   0        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               0           1     0           1      1         1       0          0         1   0        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               0           1     0           1      1         1       0          0         1   0        1
INDONESIA           0           1     0           1      1         1       0          0         1   0        1
JAPAN               0           1     0           1      1         1       0          0         1   0        1
KOREA               0           1     0           1      1         1       0          0         1   0        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            0           1     0           1      1         1       0          0         1   0        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     0           1      1         1       0          0         1   0        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          0           1     0           1      1         1       0          0         1   0        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           0           1     0           1      1         1       0          0         1   0        1
THAILAND            0           1     0           1      1         1       0          0         1   0        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             0           1     0           1      1         1       0          0         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0   ;


TABLE WAR(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BAHRAIN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRAZIL              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRUNEI              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CANADA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHILE               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHINA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
EU                  0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDIA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDONESIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
JAPAN               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KOREA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KUWAIT              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MALAYSIA            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MEXICO              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
NEWZEALAND          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PERU                0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PHILIPPINE          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
QATAR               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
RUSSIAN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ARABIA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
SINGAPORE           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
THAILAND            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
US                  0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
VIETNAM             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ROW                 0          0        0       0       0       0      0      0     0      0          0      0      0       0         0

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           0     0           0      0         0       0          0         0   0        0
BAHRAIN             0           0     0           0      0         0       0          0         0   0        0
BRAZIL              0           0     0           0      0         0       0          0         0   0        0
BRUNEI              0           0     0           0      0         0       0          0         0   0        0
CANADA              0           0     0           0      0         0       0          0         0   0        0
CHILE               0           0     0           0      0         0       0          0         0   0        0
CHINA               0           0     0           0      0         0       0          0         1   0        0
EU                  0           0     0           0      0         0       0          0         0   0        0
INDIA               0           0     0           0      0         0       0          0         0   0        0
INDONESIA           0           0     0           0      0         0       0          0         0   0        0
JAPAN               0           0     0           0      0         0       0          0         0   0        0
KOREA               0           0     0           0      0         0       0          0         0   0        0
KUWAIT              0           0     0           0      0         0       0          0         0   0        0
MALAYSIA            0           0     0           0      0         0       0          0         0   0        0
MEXICO              0           0     0           0      0         0       0          0         0   0        0
NEWZEALAND          0           0     0           0      0         0       0          0         0   0        0
PERU                0           0     0           0      0         0       0          0         0   0        0
PHILIPPINE          0           0     0           0      0         0       0          0         0   0        0
QATAR               0           0     0           0      0         0       0          0         0   0        0
RUSSIAN             0           0     0           0      0         0       0          0         0   0        0
ARABIA              0           0     0           0      0         0       0          0         0   0        0
SINGAPORE           0           0     0           0      0         0       0          0         0   0        0
THAILAND            0           0     0           0      0         0       0          0         0   0        0
US                  0           0     0           0      0         0       0          0         0   0        0
VIETNAM             0           0     0           0      0         0       0          0         0   0        0
ROW                 0           0     0           0      0         0       0          0         0   0        0   ;




***************CALIBRATION**************
PARAMETERS

DISTN(R,G,F)      SHARE PARAMETER IN PRODUCTION FUNCTION
SCALE(R,G)        SCALE PAREMETER IN PRODUCTION

SHARE1(R)         SHARE PARAMETER OF COMPOSITE TRADABLE GOODS
SHARE2(R)         SHARE PARAMETER OF NONTRADABLE GOODS
SHARE3(R)         SHARE PARAMETER OF INSIDE MONEY
SHARE4(R,RR)      SHARE PARAMETER OF TRADABLE GOODS
PM1(R)            PRICE FOR COMPOSITE TRADABLE GOODS

ELASC1(R)         FIRST LEVEL CONSUMPTION ELASTICITY OF SUBSITUTION
ELASC2(R)         SECOND LEVEL CONSUMPTION ELASTICITY OF SUBSTITUTION
ELASP(R,G)        PRODUCTION ELASTICITY OF SUBSITUTION
;


ELASC1(R) = ELASC10(R)*2;
ELASC2(R) = ELASC20(R)*2;
ELASP(R,G) = ELASP0(R,G)*2;

DISTN(R,G,F) = ((FACDEM1(R,G,F)**(1/ELASP(R,G))))/SUM(FF,(FACDEM1(R,G,FF)**(1/ELASP(R,G))));
SCALE(R,G) = PRN1(R,G)/(SUM(F,DISTN(R,G,F)*(FACDEM1(R,G,F)**((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1)));

SHARE4(R,RR) = GDEM1(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**ELASC2(R))/SUM(RRR,GDEM1(R,RRR)*((1+TARIFF(R,RRR)+NTARIFF(R,RRR))**ELASC2(R)));
PM1(R) = (SUM(RR,SHARE4(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));
SHARE1(R) = TGDEM1(R)*(PM1(R)**ELASC1(R))/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE2(R) = NGDEM1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE3(R) = MONEY1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));

DISPLAY DISTN,SCALE,PM1,SHARE1,SHARE2,SHARE3,SHARE4,ELASC1,ELASC2,ELASP;


********************MODEL SYSTEM********************
VARIABLES
PRN(R,G)            PRODUCTION OF SECTORS
FACDEM(R,G,F)       FACTOR DEMAND BY GOODS

TGDEM(R)            TRADABLE COMPOSITE GOODS
NGDEM(R)            NONTRADABLE GOODS
MONEY(R)            INSIDE MONEY
GDEM(R,RR)          TRADABLE GOODS DEMAND

P(R,G)              PRICE OF PRODUCTION
PRCT(R,RR)          PRICE OF TRADABLE GOODS
PRCN(R)             PRICE OF NON-TRADABLE GOODS
PRCM(R)             PRICE OF INSIDE MONEY
PM(R)               PRICE OF COMPOSITE TRADABLE GOODS
W(R,F)              WAGES BY FACTORS

SURPLUS(R)          TRADE IMBALANCE DENOTED BY INSIDE MONEY
REV(R)              REVENUE COLLECTION
NREV(R)             COSTS FOR SOLVING NON-TARIFF TRADE COSTS
INC(R)              INCOME BY INDIVIDUAL

Z(R)                EXCESS DEMAND OF TRADABLE GOODS
DMY                 A DUMMY OBJECTIVE VARIABLE

EQUATIONS
PRNDEF(R,G)         DEFINITION OF PRODUCTION FUNCTION
FACDEMDEF(R,G,F)    DEFINITION OF FACTOR DEMAND

TGDEMDEF(R)         DEFINITION OF TRADABLE COMPOSITE GOODS
NGDEMDEF(R)         DEFINITION OF NON-TRADABLE GOODS
MONEYDEF(R)         DEFINITION OF INSIDE MONEY
GDEMDEF(R,RR)       DEFINITION OF TRADABLE GOODS DEMAND

PRCTDEF(R,RR)       DEFINITION OF TRADABLE GOODS CONSUMER PRICE
PRCNDEF(R)          DEFINITION OF NONTRADABLE GOODS CONSUMER PRICE
PMDEF(R)            DEFINITION OF AMINGTON PRICES

SURPLUSDEF(R)       DEFINITION OF TRADE IMBALANCE DENOTED BY INSIDE MONEY
REVDEF(R)           DEFINITION OF REVENUE COLLECTION
NREVDEF(R)          DEFINITION OF COSTS FOR SLOVING NON-TARIFF BARRIERS
INCDEF(R)           INCOME DEFINITION

FACDEF(R,F)         DEFINITION OF FACTOR CLEARANCE
ZPROF(R,G)          ZERO PROFIT CONDITION
SDEF                SURPLUS CLEARANCE DEFINITION
NGDEF(R)            NONTRADABLE GOODS CLEARANCE CONDITION
TGDEF(R)            TRADABLE GOODS CLEARANCE CONDITION

DMYOBJ              DEFINITION OF DUMMY OBJECTIVE FUNCTION
;

PRNDEF(R,G)..
PRN(R,G) =E= SCALE(R,G)*SUM(F,DISTN(R,G,F)*(FACDEM(R,G,F)**
((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1));

FACDEMDEF(R,G,F)..
FACDEM(R,G,F) =E= (1/SCALE(R,G))*PRN(R,G)*(DISTN(R,G,F)+((SUM(FF,DISTN(R,G,FF))
-DISTN(R,G,F))*((DISTN(R,G,F)*(SUM(FF,W(R,FF))-W(R,F)))/((SUM(FF,DISTN(R,G,FF))-DISTN(R,G,F))*W(R,F)))**
(1-ELASP(R,G))))**(ELASP(R,G)/(1-ELASP(R,G)));

TGDEMDEF(R)..
TGDEM(R) =E= (SHARE1(R)*INC(R))/((PM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

NGDEMDEF(R)..
NGDEM(R) =E= (SHARE2(R)*INC(R))/((PRCN(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

MONEYDEF(R)..
MONEY(R) =E= (SHARE3(R)*INC(R))/((PRCM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

GDEMDEF(R,RR)..
GDEM(R,RR) =E= (SHARE4(R,RR)*PM(R)*TGDEM(R))/((PRCT(R,RR)**ELASC2(R))*SUM(RRR,SHARE4(R,RRR)*(PRCT(R,RRR)**(1-ELASC2(R)))));

PRCTDEF(R,RR)..
PRCT(R,RR) =E= P(RR,"TRADABLE")*(1+TARIFF(R,RR)+0.10*RTA(R,RR)+NTARIFF(R,RR));

PRCNDEF(R)..
PRCN(R) =E= P(R,"NONTRADABLE");

PMDEF(R)..
PM(R) =E= (SUM(RR,SHARE4(R,RR)*(PRCT(R,RR)**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));

SURPLUSDEF(R)..
SURPLUS(R) =E= MONEY(R)-1000;

REVDEF(R)..
REV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*(TARIFF(R,RR)+0.10*RTA(R,RR)));

NREVDEF(R)..
NREV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*NTARIFF(R,RR));

INCDEF(R)..
INC(R) =E= SUM(FF,ENDW(R,FF)*W(R,FF)*((1+GROWTH(R))**4))+REV(R)+1000;

FACDEF(R,F)..
ENDW(R,F)*((1+GROWTH(R))**4) =E= SUM(G,FACDEM(R,G,F));

ZPROF(R,G)..
PRN(R,G)*P(R,G) =E= SUM(F,FACDEM(R,G,F)*W(R,F));

SDEF..
SUM(R,SURPLUS(R)) =E= 0;

NGDEF(R)..
NGDEM(R) =E= PRN(R,"NONTRADABLE")-(NREV(R)/PRCN(R));

TGDEF(R)..
Z(R) =E= SUM(RR,GDEM(RR,R))-PRN(R,"TRADABLE");

DMYOBJ..
DMY =E= SUM(R,P(R,"TRADABLE")*Z(R)*P(R,"TRADABLE")*Z(R))/10000;

MODEL CHUNDING /ALL/;

PRN.LO(R,G)=0.1;
PRN.LO("AUSTRALIA",G)=100;
PRN.LO("BAHRAIN",G)=2;
PRN.LO("BRAZIL",G)=100;
PRN.LO("BRUNEI",G)=1;
PRN.LO("CANADA",G)=100;
PRN.LO("CHILE",G)=10;
PRN.LO("CHINA",G)=1000;
PRN.LO("EU",G)=1000;
PRN.LO("INDIA",G)=100;
PRN.LO("INDONESIA",G)=50;
PRN.LO("JAPAN",G)=100;
PRN.LO("KOREA",G)=60;
PRN.LO("KUWAIT",G)=1;
PRN.LO("MALAYSIA",G)=10;
PRN.LO("MEXICO",G)=50;
PRN.LO("NEWZEALAND",G)=2;
PRN.LO("PERU",G)=10;
PRN.LO("PHILIPPINE",G)=10;
PRN.LO("QATAR",G)=6;
PRN.LO("RUSSIAN",G)=100;
PRN.LO("ARABIA",G)=10;
PRN.LO("SINGAPORE",G)=100;
PRN.LO("THAILAND",G)=5;
PRN.LO("US",G)=100;
PRN.LO("VIETNAM",G)=10;
PRN.LO("ROW",G)=500;

FACDEM.LO(R,G,F)=0.1;
FACDEM.LO("AUSTRALIA",G,F)=60;
FACDEM.LO("BAHRAIN",G,F)=1;
FACDEM.LO("BRAZIL",G,F)=10;
FACDEM.LO("BRUNEI",G,F)=0.1;
FACDEM.LO("CANADA",G,F)=20;
FACDEM.LO("CHILE",G,F)=5;
FACDEM.LO("CHINA",G,F)=600;
FACDEM.LO("EU",G,F)=600;
FACDEM.LO("INDIA",G,F)=20;
FACDEM.LO("INDONESIA",G,F)=30;
FACDEM.LO("JAPAN",G,F)=60;
FACDEM.LO("KOREA",G,F)=50;
FACDEM.LO("KUWAIT",G,F)=1;
FACDEM.LO("MALAYSIA",G,F)=10;
FACDEM.LO("MEXICO",G,F)=20;
FACDEM.LO("NEWZEALAND",G,F)=2;
FACDEM.LO("PERU",G,F)=5;
FACDEM.LO("PHILIPPINE",G,F)=6;
FACDEM.LO("QATAR",G,F)=3;
FACDEM.LO("RUSSIAN",G,F)=20;
FACDEM.LO("ARABIA",G,F)=20;
FACDEM.LO("SINGAPORE",G,F)=5;
FACDEM.LO("THAILAND",G,F)=2;
FACDEM.LO("US",G,F)=100;
FACDEM.LO("VIETNAM",G,F)=2;
FACDEM.LO("ROW",G,F)=200;

TGDEM.LO(R)=0.1;
TGDEM.LO("AUSTRALIA")=100;
TGDEM.LO("BAHRAIN")=2;
TGDEM.LO("BRAZIL")=60;
TGDEM.LO("BRUNEI")=1;
TGDEM.LO("CANADA")=100;
TGDEM.LO("CHILE")=10;
TGDEM.LO("CHINA")=1000;
TGDEM.LO("EU")=1000;
TGDEM.LO("INDIA")=100;
TGDEM.LO("INDONESIA")=60;
TGDEM.LO("JAPAN")=300;
TGDEM.LO("KOREA")=100;
TGDEM.LO("KUWAIT")=5;
TGDEM.LO("MALAYSIA")=50;
TGDEM.LO("MEXICO")=100;
TGDEM.LO("NEWZEALAND")=10;
TGDEM.LO("PERU")=10;
TGDEM.LO("PHILIPPINE")=20;
TGDEM.LO("QATAR")=5;
TGDEM.LO("RUSSIAN")=100;
TGDEM.LO("ARABIA")=60;
TGDEM.LO("SINGAPORE")=60;
TGDEM.LO("THAILAND")=60;
TGDEM.LO("US")=1000;
TGDEM.LO("VIETNAM")=20;
TGDEM.LO("ROW")=1000;

NGDEM.LO(R)=0.1;
NGDEM.LO("AUSTRALIA")=100;
NGDEM.LO("BAHRAIN")=1;
NGDEM.LO("BRAZIL")=100;
NGDEM.LO("BRUNEI")=1;
NGDEM.LO("CANADA")=500;
NGDEM.LO("CHILE")=10;
NGDEM.LO("CHINA")=1000;
NGDEM.LO("EU")=1000;
NGDEM.LO("INDIA")=500;
NGDEM.LO("INDONESIA")=60;
NGDEM.LO("JAPAN")=600;
NGDEM.LO("KOREA")=100;
NGDEM.LO("KUWAIT")=5;
NGDEM.LO("MALAYSIA")=10;
NGDEM.LO("MEXICO")=100;
NGDEM.LO("NEWZEALAND")=10;
NGDEM.LO("PERU")=10;
NGDEM.LO("PHILIPPINE")=20;
NGDEM.LO("QATAR")=5;
NGDEM.LO("RUSSIAN")=100;
NGDEM.LO("ARABIA")=20;
NGDEM.LO("SINGAPORE")=60;
NGDEM.LO("THAILAND")=10;
NGDEM.LO("US")=1000;
NGDEM.LO("VIETNAM")=10;
NGDEM.LO("ROW")=500;

MONEY.LO(R)=100;
MONEY.LO("AUSTRALIA")=800;
MONEY.LO("BAHRAIN")=800;
MONEY.LO("BRAZIL")=800;
MONEY.LO("BRUNEI")=800;
MONEY.LO("CANADA")=600;
MONEY.LO("CHILE")=600;
MONEY.LO("CHINA")=900;
MONEY.LO("EU")=800;
MONEY.LO("INDIA")=500;
MONEY.LO("INDONESIA")=600;
MONEY.LO("JAPAN")=500;
MONEY.LO("KOREA")=800;
MONEY.LO("KUWAIT")=800;
MONEY.LO("MALAYSIA")=800;
MONEY.LO("MEXICO")=600;
MONEY.LO("NEWZEALAND")=600;
MONEY.LO("PERU")=600;
MONEY.LO("PHILIPPINE")=600;
MONEY.LO("QATAR")=800;
MONEY.LO("RUSSIAN")=900;
MONEY.LO("ARABIA")=900;
MONEY.LO("SINGAPORE")=800;
MONEY.LO("THAILAND")=600;
MONEY.LO("US")=100;
MONEY.LO("VIETNAM")=600;
MONEY.LO("ROW")=800;

REV.LO(R)=0.05;
REV.LO("AUSTRALIA")=2;
REV.LO("BAHRAIN")=0.1;
REV.LO("BRAZIL")=6;
REV.LO("BRUNEI")=0.2;
REV.LO("CANADA")=6;
REV.LO("CHILE")=2;
REV.LO("CHINA")=60;
REV.LO("EU")=20;
REV.LO("INDIA")=10;
REV.LO("INDONESIA")=3;
REV.LO("JAPAN")=10;
REV.LO("KOREA")=10;
REV.LO("KUWAIT")=0.2;
REV.LO("MALAYSIA")=2;
REV.LO("MEXICO")=2;
REV.LO("NEWZEALAND")=0.2;
REV.LO("PERU")=0.3;
REV.LO("PHILIPPINE")=1;
REV.LO("QATAR")=0.2;
REV.LO("RUSSIAN")=2;
REV.LO("ARABIA")=2;
REV.LO("SINGAPORE")=0.1;
REV.LO("THAILAND")=2;
REV.LO("US")=10;
REV.LO("VIETNAM")=2;
REV.LO("ROW")=50;

NREV.LO(R)=0.1;
NREV.LO("AUSTRALIA")=10;
NREV.LO("BAHRAIN")=1;
NREV.LO("BRAZIL")=6;
NREV.LO("BRUNEI")=0.2;
NREV.LO("CANADA")=6;
NREV.LO("CHILE")=2;
NREV.LO("CHINA")=60;
NREV.LO("EU")=20;
NREV.LO("INDIA")=10;
NREV.LO("INDONESIA")=10;
NREV.LO("JAPAN")=50;
NREV.LO("KOREA")=10;
NREV.LO("KUWAIT")=2;
NREV.LO("MALAYSIA")=2;
NREV.LO("MEXICO")=10;
NREV.LO("NEWZEALAND")=2;
NREV.LO("PERU")=3;
NREV.LO("PHILIPPINE")=5;
NREV.LO("QATAR")=1;
NREV.LO("RUSSIAN")=10;
NREV.LO("ARABIA")=6;
NREV.LO("SINGAPORE")=10;
NREV.LO("THAILAND")=2;
NREV.LO("US")=60;
NREV.LO("VIETNAM")=2;
NREV.LO("ROW")=100;

INC.LO(R)=1;
INC.LO("AUSTRALIA")=600;
INC.LO("BAHRAIN")=10;
INC.LO("BRAZIL")=600;
INC.LO("BRUNEI")=2;
INC.LO("CANADA")=600;
INC.LO("CHILE")=60;
INC.LO("CHINA")=1000;
INC.LO("EU")=2000;
INC.LO("INDIA")=500;
INC.LO("INDONESIA")=100;
INC.LO("JAPAN")=500;
INC.LO("KOREA")=100;
INC.LO("KUWAIT")=10;
INC.LO("MALAYSIA")=60;
INC.LO("MEXICO")=100;
INC.LO("NEWZEALAND")=20;
INC.LO("PERU")=50;
INC.LO("PHILIPPINE")=60;
INC.LO("QATAR")=10;
INC.LO("RUSSIAN")=500;
INC.LO("ARABIA")=100;
INC.LO("SINGAPORE")=100;
INC.LO("THAILAND")=100;
INC.LO("US")=1000;
INC.LO("VIETNAM")=10;
INC.LO("ROW")=1000;

*GDEM.LO(R,RR)=0.1;

P.LO(R,G)=0.3;
PRCT.LO(R,RR)=0.4;
PRCN.LO(R)=0.5;
PM.LO(R)=0.5;
W.LO(R,F)=0.2;
PRCM.FX(R)=1;
W.FX("ARABIA","L")=1;

SOLVE CHUNDING USING NLP MINIMIZING DMY;

DISPLAY PRN.L, FACDEM.L, TGDEM.L, NGDEM.L, MONEY.L, GDEM.L, P.L, PRCT.L, PRCN.L, PM.L, W.L, SURPLUS.L, REV.L, INC.L;


***************SPECIFIC CALCULATION******************
PARAMETERS

PRODUCTION0(R)
/AUSTRALIA   1275.244,    BAHRAIN       25.544,    BRAZIL      1733.435
BRUNEI         7.440,    CANADA      2280.581,    CHILE        247.276
CHINA      17049.839,    EU         22278.357,    INDIA       2958.316
INDONESIA    891.484,    JAPAN       5180.736,    KOREA       1741.129
KUWAIT        82.275,    MALAYSIA     339.918,    MEXICO      1701.687
NEWZEALAND   173.966,    PERU         179.390,    PHILIPPINE   249.489
QATAR        111.014,    RUSSIAN     1636.787,    ARABIA       854.341
SINGAPORE    751.983,    THAILAND     459.273,    US         29969.568
VIETNAM      487.436,    ROW         9722.496/,

PRODUCTIONT0(R)
/AUSTRALIA   205.013,    BAHRAIN       1.983,    BRAZIL      289.868
BRUNEI        0.537,    CANADA     1225.622,    CHILE        16.477
CHINA      8501.259,    EU         5824.983,    INDIA      1263.314
INDONESIA   376.407,    JAPAN      1684.976,    KOREA       888.204
KUWAIT        2.331,    MALAYSIA    236.265,    MEXICO     1074.016
NEWZEALAND    6.421,    PERU         17.869,    PHILIPPINE   15.225
QATAR         3.936,    RUSSIAN     550.227,    ARABIA      461.701
SINGAPORE   499.978,    THAILAND    234.003,    US         6930.033
VIETNAM     357.145,    ROW        6239.980/,

PRODUCTIONNT0(R)
/AUSTRALIA   1070.231,    BAHRAIN       23.561,    BRAZIL      1443.567
BRUNEI         6.903,    CANADA      1054.959,    CHILE        230.798
CHINA       8548.580,    EU         16453.374,    INDIA       1695.002
INDONESIA    515.077,    JAPAN       3495.760,    KOREA        852.925
KUWAIT        79.944,    MALAYSIA     103.653,    MEXICO       627.670
NEWZEALAND   167.545,    PERU         161.521,    PHILIPPINE   234.265
QATAR        107.078,    RUSSIAN     1086.560,    ARABIA       392.640
SINGAPORE    252.005,    THAILAND     225.270,    US         23039.535
VIETNAM      130.291,    ROW         3482.516/,

EXPORT0(R)        TOTAL EXPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   368.060,    BAHRAIN      33.396,    BRAZIL      391.481
BRUNEI       13.315,    CANADA      616.897,    CHILE       131.519
CHINA      3524.373,    EU         3304.394,    INDIA       538.580
INDONESIA   302.637,    JAPAN       969.434,    KOREA       815.994
KUWAIT      160.555,    MALAYSIA    376.749,    MEXICO      579.814
NEWZEALAND   65.681,    PERU         87.899,    PHILIPPINE  137.758
QATAR       180.104,    RUSSIAN     693.418,    ARABIA      391.785
SINGAPORE   632.014,    THAILAND    364.277,    US         1679.740
VIETNAM     362.388,    ROW        4559.627/,

IMPORT0(R)        TOTAL IMPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   208.735,    BAHRAIN      21.635,    BRAZIL      163.642
BRUNEI        4.494,    CANADA      554.106,    CHILE        67.945
CHINA      2927.739,    EU         3219.968,    INDIA       576.194
INDONESIA   164.235,    JAPAN       853.462,    KOREA       584.257
KUWAIT       35.004,    MALAYSIA    220.826,    MEXICO      568.659
NEWZEALAND   43.358,    PERU         41.412,    PHILIPPINE  108.365
QATAR        26.946,    RUSSIAN     235.918,    ARABIA      143.583
SINGAPORE   412.981,    THAILAND    251.517,    US         4717.127
VIETNAM     259.731,    ROW        4870.048/,

BALANCE0(R)       TOTAL IMBALNCE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA    159.325,    BAHRAIN       11.761,    BRAZIL       227.839
BRUNEI         8.821,    CANADA        62.791,    CHILE         63.574
CHINA        596.634,    EU            84.426,    INDIA        -37.614
INDONESIA    138.402,    JAPAN        115.972,    KOREA        231.737
KUWAIT       125.550,    MALAYSIA     155.923,    MEXICO        11.154
NEWZEALAND    22.323,    PERU          46.488,    PHILIPPINE    29.393
QATAR        153.158,    RUSSIAN      457.500,    ARABIA       248.201
SINGAPORE    219.033,    THAILAND     112.759,    US         -3037.387
VIETNAM      102.657,    ROW         -310.421/,

TRADE0(R)         TOTAL TRADE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   576.795,    BAHRAIN      55.031,    BRAZIL      555.123
BRUNEI       17.809,    CANADA     1171.004,    CHILE       199.464
CHINA      6452.113,    EU         6524.361,    INDIA      1114.773
INDONESIA   466.872,    JAPAN      1822.896,    KOREA      1400.251
KUWAIT      195.559,    MALAYSIA    597.575,    MEXICO     1148.473
NEWZEALAND  109.039,    PERU        129.311,    PHILIPPINE  246.123
QATAR       207.050,    RUSSIAN     929.336,    ARABIA      535.368
SINGAPORE  1044.996,    THAILAND    615.794,    US         6396.867
VIETNAM     622.119,    ROW        9429.676/,

NGDEM0(R)       NON-TRADABLE GOODS DEMAND IN BASE CASE
/AUSTRALIA   1222.237,    BAHRAIN       23.790,    BRAZIL      1598.456
BRUNEI         7.877,    CANADA       745.240,    CHILE        272.109
CHINA       7797.531,    EU         14108.283,    INDIA       1707.698
INDONESIA    601.058,    JAPAN       3123.513,    KOREA        822.266
KUWAIT       116.445,    MALAYSIA      89.327,    MEXICO       347.686
NEWZEALAND   192.252,    PERU         184.311,    PHILIPPINE   267.034
QATAR        172.923,    RUSSIAN     1075.673,    ARABIA       353.997
SINGAPORE    171.790,    THAILAND     225.802,    US         16399.759
VIETNAM       83.191,    ROW         1721.913/,

UTILITY0(R)     TOTAL UTILITY IN BASE CASE
/AUSTRALIA   1485.157,    BAHRAIN       54.271,    BRAZIL      1887.016
BRUNEI        16.994,    CANADA      1658.682,    CHILE        336.648
CHINA      15755.610,    EU         19663.404,    INDIA       3220.721
INDONESIA   1167.349,    JAPAN       4808.627,    KOREA       1669.434
KUWAIT       139.084,    MALAYSIA     350.305,    MEXICO      1147.149
NEWZEALAND   242.968,    PERU         253.605,    PHILIPPINE   436.628
QATAR        196.728,    RUSSIAN     1442.103,    ARABIA       639.636
SINGAPORE    652.968,    THAILAND     534.444,    US         23193.880
VIETNAM      467.331,    ROW         7361.654/,

PRCN0(R)       CONSUMPTION PICE OF NON-TRADABLE GOODS IN BASE CASE
/AUSTRALIA  0.820,    BAHRAIN    0.644,    BRAZIL     0.875,    BRUNEI     0.537
CANADA     1.255,    CHILE      0.760,    CHINA      1.034,    EU         1.124
INDIA      0.945,    INDONESIA  0.760,    JAPAN      1.053,    KOREA      0.989
KUWAIT     0.582,    MALAYSIA   0.851,    MEXICO     1.383,    NEWZEALAND 0.771
PERU       0.750,    PHILIPPINE 0.684,    QATAR      0.563,    RUSSIAN    0.958
ARABIA     1.000,    SINGAPORE  1.026,    THAILAND   0.909,    US         1.352
VIETNAM    0.936,    ROW        0.805/,

EMPLOYMENT0(R)
/AUSTRALIA   190.109,    BAHRAIN       2.077,    BRAZIL      281.467
BRUNEI        0.612,    CANADA      752.126,    CHILE        16.670
CHINA      4602.833,    EU         4094.150,    INDIA       922.069
INDONESIA   321.827,    JAPAN      1216.096,    KOREA       628.691
KUWAIT        3.008,    MALAYSIA    210.993,    MEXICO      597.996
NEWZEALAND    6.332,    PERU         18.825,    PHILIPPINE   16.263
QATAR         3.990,    RUSSIAN     442.537,    ARABIA      350.874
SINGAPORE   355.693,    THAILAND    193.167,    US         2809.230
VIETNAM     278.519,    ROW        5894.510/,

GDEM0(R,RR)     GOODS DEMAND IN THE BASE CASE
PRCT0(R,RR)     CONSUMPTION PRICE OF TRADABLE GOODS IN BASE CASE
;


TABLE GDEM0(R,RR)
             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA      166.764       0.157       0.755       1.758       0.943
BAHRAIN          1.436      12.768       0.896                   0.120
BRAZIL           1.529       0.257     221.951       0.003       1.307
BRUNEI           0.076                   0.001       7.893       0.005
CANADA           3.318       0.093       7.631       0.029     265.671
CHILE            0.360       0.002       8.175       0.003       0.530
CHINA          196.606       0.457     126.543       1.081      22.644
EU              25.482       5.306      62.993       0.685      29.759
INDIA           21.524       1.447       6.193       1.542       2.262
INDONESIA        7.326       0.140       1.988       0.062       0.988
JAPAN           73.315       3.222       9.690       8.483       8.036
KOREA           31.933       1.404       5.281       2.194       3.784
KUWAIT                       1.753       0.359       0.003       0.146
MALAYSIA         7.748       0.256       2.497       1.462       0.501
MEXICO           0.678       0.149      11.792       0.005       9.485
NEWZEALAND       7.281       0.021       0.160       0.003       0.302
PERU             0.169       0.002       3.085                   0.437
PHILIPPINE       2.075       0.052       0.759       0.113       0.456
QATAR            0.953       0.020       0.382                   0.098
RUSSIAN          0.999       0.017       3.227                   0.474
ARABIA           1.027       3.981       3.204       0.004       1.158
SINGAPORE        8.469       0.311       2.116       1.898       1.022
THAILAND         8.367       0.379       2.551       2.821       0.590
US              28.666       4.656      79.484       0.667     390.346
VIETNAM          4.989       0.033       2.512       0.189       0.532
ROW             14.692      27.705     104.923       1.786      15.771

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        0.561      46.993      28.877       3.750       4.222
BAHRAIN          0.182       1.790       2.057       0.878       0.153
BRAZIL           5.343      29.656      28.025       3.744       2.103
BRUNEI           0.004       1.663       0.619       0.084       0.135
CANADA           3.325      75.066      52.511       6.099       3.235
CHILE           40.076      15.350       8.623       1.026       0.315
CHINA           58.700    4728.615     243.959      26.518      58.994
EU              21.501     565.133    2100.903      78.531      43.894
INDIA            2.965      70.665      42.889     919.806      24.387
INDONESIA        0.168      35.965       7.449       4.744     536.447
JAPAN           13.818     175.000      63.395       6.634      36.338
KOREA            8.016     103.091      47.171       6.820      17.078
KUWAIT           0.052       5.278       4.925       1.966       0.372
MALAYSIA         0.211      39.437      12.769       7.149      15.901
MEXICO           4.003     108.394      50.543       8.130       3.812
NEWZEALAND       0.150       7.875       5.093       0.555       1.084
PERU             2.314       9.204       3.370       0.988       0.484
PHILIPPINE       0.064      19.132       6.409       1.810      10.646
QATAR            0.022       3.334       8.970       2.029       0.235
RUSSIAN          1.831      48.847      78.999       3.612       2.969
ARABIA           0.272      22.110      29.157       6.765       2.903
SINGAPORE        0.164      48.381      35.919       8.474      23.437
THAILAND         0.740      44.229      13.137       5.155      13.183
US              39.811     993.235     706.036     119.165      60.289
VIETNAM          0.513      57.297      10.752       4.635       6.623
ROW              8.232     880.328    1448.226     260.472      65.257

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        3.333       9.070       0.108       9.997       0.456
BAHRAIN          0.731       0.262       0.338       0.193       0.039
BRAZIL           3.588       5.025       0.575       1.931       2.087
BRUNEI     9.775529E-4       0.107                   0.675       0.002
CANADA          16.140      10.270       0.126       4.376      10.105
CHILE            2.107       1.794                   0.320       1.010
CHINA          204.514     262.903      57.065      59.723       4.712
EU              97.148      79.784      14.890      54.149      20.742
INDIA           11.612      17.208      23.693      12.749       0.740
INDONESIA       13.698       7.851       0.667      10.035       0.127
JAPAN          746.950      35.402      23.100      25.470       1.847
KOREA           50.998     207.526      39.162      11.930       1.233
KUWAIT           1.792       1.359      34.886       0.400       0.103
MALAYSIA        13.816       9.588       1.376      22.725       0.187
MEXICO          22.777      23.743       0.070       3.974     121.979
NEWZEALAND       2.669       1.997       0.026       1.947       0.162
PERU             0.930       0.973       0.003       0.316       0.843
PHILIPPINE       9.317      10.660       3.735       5.362       0.073
QATAR            1.136       0.548       0.880       0.405       0.091
RUSSIAN          7.962       7.171                   2.248       0.491
ARABIA           5.249       4.676       1.311       1.713       0.414
SINGAPORE       20.829      15.131      12.553      49.625       1.279
THAILAND        30.119       8.567       2.601      18.389       0.323
US             248.236     146.975      11.855      58.669     340.004
VIETNAM         15.976      50.257       0.891      12.252       0.431
ROW            135.931     113.736      80.997      95.818      31.763

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        8.885       0.397       1.027       0.975       0.172
BAHRAIN          0.091       0.004       0.063                   0.110
BRAZIL           0.094       2.941       0.529       0.786       3.361
BRUNEI           0.009                   0.032       0.010       0.001
CANADA           1.342       2.690       3.301       0.300       1.713
CHILE            0.218       1.928       0.104                   0.073
CHINA           23.449      33.998      23.380      36.035      80.726
EU               8.920      16.602      26.018      34.948     254.667
INDIA            1.095       4.481       1.351      34.286       7.617
INDONESIA        1.149       0.084       1.731       3.759       1.429
JAPAN            4.813       4.704      21.843      50.514      18.329
KOREA            2.405       4.555       5.629      53.210      19.769
KUWAIT           0.108       0.007       0.143       0.152       0.236
MALAYSIA         1.355       0.194       4.018       2.076       1.229
MEXICO           0.680       1.170       1.799       0.258       2.982
NEWZEALAND      37.911       0.068       0.206       0.169       0.176
PERU             0.219      65.083       0.121       0.059       0.468
PHILIPPINE       0.791       0.174     125.798       1.112       1.286
QATAR            0.049       0.117       0.140      94.776       0.280
RUSSIAN          0.229       0.324       0.892       0.114     144.054
ARABIA           0.852       0.021       0.584                   1.416
SINGAPORE        1.419       0.024       9.441      22.306       6.551
THAILAND         1.147       0.227       5.503      10.549       2.474
US              13.862      27.744      42.565       9.631      44.431
VIETNAM          0.885       0.218       2.593       0.456       1.590
ROW             11.159      14.528      48.426      58.107     273.028

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        0.415       7.301      12.164      11.469       3.945
BAHRAIN          6.949       0.108       0.353       0.656       0.201
BRAZIL           2.118       0.560       1.827      14.309       2.147
BRUNEI           0.002       0.385       0.143       0.209       0.021
CANADA           4.047       1.274       4.586     172.781       4.738
CHILE            0.031       0.090       1.122       7.009       0.822
CHINA           57.700      40.164      68.409     104.659      59.360
EU              46.903      29.030      42.347     217.544      66.916
INDIA           29.201      14.084       9.515      17.932       7.672
INDONESIA        4.150      17.205      11.212       4.605       3.409
JAPAN           36.421       9.969      32.736      48.094      23.184
KOREA           27.276       7.844       7.004      32.655      21.565
KUWAIT           1.928       0.135       0.468       1.564       0.568
MALAYSIA         4.318      23.566      14.201       8.366       4.520
MEXICO           0.124       2.201      10.697     160.267       3.549
NEWZEALAND       0.377       1.367       2.268       2.302       0.711
PERU             0.179       0.063       0.476       4.792       0.394
PHILIPPINE       1.715       5.434       8.728       4.014       3.585
QATAR            0.014       0.185       0.405       3.003       0.268
RUSSIAN          0.292       0.826       2.250       6.778       2.794
ARABIA         119.203       1.302       2.567      10.238       1.924
SINGAPORE       13.171      10.003      10.474      23.430       4.127
THAILAND         6.930       6.924      40.278       7.684       5.696
US              46.442      48.166      75.487    2274.059     102.471
VIETNAM          1.371       5.290      13.577       5.221      79.135
ROW             99.712     392.475      67.931     357.514      62.592

         +         ROW

AUSTRALIA       60.917
BAHRAIN          5.149
BRAZIL          53.872
BRUNEI           0.337
CANADA         117.707
CHILE           17.556
CHINA         1435.350
EU            1682.240
INDIA          293.065
INDONESIA       32.997
JAPAN          207.224
KOREA          134.889
KUWAIT          13.452
MALAYSIA        59.791
MEXICO          89.367
NEWZEALAND       8.362
PERU            12.351
PHILIPPINE      18.181
QATAR            2.372
RUSSIAN         63.449
ARABIA          45.504
SINGAPORE      139.317
THAILAND        78.482
US            1017.442
VIETNAM         77.993
ROW           1840.114 ;

TABLE PRCT0(R,RR)

             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA        0.820       1.212       1.812       0.885       2.154
BAHRAIN          1.541       0.644       1.662       0.569       2.447
BRAZIL           1.697       1.223       0.875       0.610       2.034
BRUNEI           1.611       1.013       1.376       0.537       1.972
CANADA           1.407       1.257       1.419       0.560       1.255
CHILE            1.484       0.683       1.274       0.569       1.969
CHINA            1.080       1.109       1.235       0.839       1.723
EU               1.257       1.009       1.264       1.107       1.708
INDIA            1.269       0.943       1.389       0.648       1.931
INDONESIA        1.325       1.336       1.641       0.878       2.194
JAPAN            1.130       1.047       1.423       0.819       1.774
KOREA            1.026       0.927       1.219       0.723       1.665
KUWAIT           1.590       0.984       1.564       0.562       2.467
MALAYSIA         1.025       0.959       1.311       0.679       1.793
MEXICO           1.525       1.469       1.351       0.579       1.602
NEWZEALAND       1.066       0.657       1.933       0.871       2.143
PERU             1.967       0.666       1.470       0.555       2.025
PHILIPPINE       1.456       0.685       1.710       1.043       2.142
QATAR            1.393       0.873       1.502       0.563       2.255
RUSSIAN          1.673       0.707       1.547       0.589       2.286
ARABIA           1.582       0.824       1.424       0.568       2.033
SINGAPORE        0.977       0.889       1.316       0.649       1.792
THAILAND         0.945       0.815       1.209       0.650       1.661
US               1.281       1.074       1.272       1.126       1.300
VIETNAM          1.106       0.706       1.344       0.796       1.814
ROW              1.001       0.701       1.035       0.825       1.554

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        1.376       1.362       1.723       1.463       1.229
BAHRAIN          0.805       1.780       1.760       1.383       1.576
BRAZIL           1.106       1.459       1.623       1.500       1.425
BRUNEI           1.195       1.946       2.675       1.486       1.484
CANADA           1.193       1.420       1.530       1.455       1.330
CHILE            0.760       1.427       1.665       1.483       1.610
CHINA            1.049       1.034       1.466       1.333       1.111
EU               1.126       1.349       1.124       1.295       1.261
INDIA            1.193       1.458       1.540       0.945       1.111
INDONESIA        1.610       1.511       1.865       1.381       0.760
JAPAN            1.169       1.297       1.597       1.431       1.085
KOREA            0.998       1.178       1.411       1.231       0.995
KUWAIT           0.796       1.577       1.687       1.247       1.401
MALAYSIA         1.253       1.171       1.430       1.132       0.907
MEXICO           1.149       1.528       1.612       1.467       1.519
NEWZEALAND       1.542       1.566       1.807       1.669       1.362
PERU             1.117       1.650       1.906       1.703       1.844
PHILIPPINE       1.630       1.539       1.882       1.676       1.296
QATAR            1.621       1.521       1.524       1.205       1.330
RUSSIAN          1.608       1.457       1.359       1.570       1.448
ARABIA           1.647       1.409       1.530       1.152       1.225
SINGAPORE        1.383       1.169       1.349       1.068       0.833
THAILAND         1.096       1.183       1.341       1.113       0.890
US               1.073       1.329       1.443       1.325       1.246
VIETNAM          1.195       1.200       1.461       1.182       1.065
ROW              0.975       1.779       1.938       1.687       1.157

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        1.452       1.238       1.128       1.064       2.574
BAHRAIN          1.711       1.422       0.888       1.266       3.153
BRAZIL           1.712       1.377       1.039       1.275       2.134
BRUNEI           1.941       1.647       0.914       1.346       2.174
CANADA           1.489       1.312       1.144       1.216       1.766
CHILE            1.620       1.298       0.617       1.403       2.090
CHINA            1.321       1.121       0.887       0.963       2.043
EU               1.496       1.241       0.873       1.083       1.983
INDIA            1.594       1.288       0.767       1.020       2.146
INDONESIA        1.503       1.295       1.072       1.015       2.763
JAPAN            1.053       1.132       0.826       1.000       2.141
KOREA            1.206       0.989       0.705       0.990       1.875
KUWAIT           1.495       1.199       0.582       1.414       1.448
MALAYSIA         1.237       1.051       0.966       0.851       2.178
MEXICO           1.630       1.341       0.628       1.340       1.383
NEWZEALAND       1.649       1.393       0.593       1.134       2.639
PERU             1.871       1.476       0.601       1.638       2.344
PHILIPPINE       1.538       1.290       1.316       1.128       2.601
QATAR            1.341       1.115       0.950       1.157       2.666
RUSSIAN          1.561       1.291       0.638       1.386       2.676
ARABIA           1.425       1.131       0.900       1.209       2.617
SINGAPORE        1.263       1.002       1.055       0.989       2.051
THAILAND         1.198       1.132       0.901       0.949       1.868
US               1.404       1.199       0.875       1.066       1.481
VIETNAM          1.259       1.097       1.019       0.960       2.251
ROW              1.195       1.105       0.688       0.963       1.723

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        1.002       1.800       1.215       0.957       1.954
BAHRAIN          0.816       0.794       0.724       0.763       1.014
BRAZIL           1.702       1.259       1.336       0.966       1.692
BRUNEI           1.495       1.179       1.546       0.885       1.505
CANADA           1.316       1.211       1.167       1.012       1.745
CHILE            1.563       1.102       1.466       1.201       2.025
CHINA            1.167       1.196       1.018       0.828       1.349
EU               1.239       1.272       1.145       0.764       1.158
INDIA            1.361       1.352       1.212       0.718       1.591
INDONESIA        1.381       1.820       1.165       0.985       1.824
JAPAN            1.207       1.333       0.999       0.717       1.419
KOREA            1.085       1.119       0.892       0.652       1.250
KUWAIT           0.807       0.785       1.548       0.920       1.003
MALAYSIA         1.027       1.444       0.906       0.765       1.559
MEXICO           1.470       1.271       1.286       1.086       1.853
NEWZEALAND       0.771       1.639       1.219       0.972       1.864
PERU             1.684       0.750       1.574       0.582       2.083
PHILIPPINE       1.374       1.726       0.684       1.000       2.003
QATAR            1.330       0.787       1.214       0.563       2.138
RUSSIAN          1.501       1.631       1.431       1.258       0.958
ARABIA           1.283       1.889       1.290       0.796       1.943
SINGAPORE        0.998       1.605       0.831       0.630       1.500
THAILAND         0.986       1.180       0.826       0.634       1.353
US               1.248       1.165       1.103       0.868       1.513
VIETNAM          1.134       1.583       1.015       0.822       1.386
ROW              1.014       1.034       1.174       0.680       1.080

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        1.930       1.222       1.048       2.140       1.263
BAHRAIN          1.279       1.415       1.148       2.282       1.074
BRAZIL           1.627       1.541       1.255       1.989       1.437
BRUNEI           1.572       1.668       1.480       3.304       1.686
CANADA           1.620       1.464       1.203       1.539       1.353
CHILE            2.166       1.865       1.310       1.931       1.471
CHINA            1.362       1.158       1.076       1.759       1.086
EU               1.361       1.230       1.084       1.758       1.217
INDIA            1.219       1.214       1.069       1.919       1.170
INDONESIA        1.611       1.123       1.063       2.244       1.311
JAPAN            1.353       1.229       1.034       1.825       1.119
KOREA            1.144       1.244       1.040       1.659       1.132
KUWAIT           1.547       1.859       1.407       2.060       1.639
MALAYSIA         1.420       1.191       1.013       1.714       1.149
MEXICO           1.892       1.521       1.227       1.603       1.524
NEWZEALAND       1.665       1.328       1.162       2.216       1.378
PERU             2.519       2.195       1.429       2.126       1.975
PHILIPPINE       1.886       1.246       1.098       2.208       1.389
QATAR            1.413       1.147       1.023       2.109       1.366
RUSSIAN          2.029       1.606       1.284       2.163       1.354
ARABIA           1.000       1.347       1.204       1.870       1.330
SINGAPORE        1.314       1.026       1.026       1.639       0.944
THAILAND         1.325       1.157       0.909       1.617       1.154
US               1.366       1.227       1.073       1.369       1.217
VIETNAM          1.421       1.137       1.029       1.780       0.936
ROW              1.152       1.198       1.008       1.517       1.529

         +         ROW

AUSTRALIA        0.982
BAHRAIN          0.956
BRAZIL           0.951
BRUNEI           1.492
CANADA           0.997
CHILE            1.031
CHINA            0.982
EU               0.904
INDIA            0.981
INDONESIA        1.225
JAPAN            0.913
KOREA            0.979
KUWAIT           0.952
MALAYSIA         0.910
MEXICO           1.002
NEWZEALAND       1.059
PERU             1.109
PHILIPPINE       1.381
QATAR            0.972
RUSSIAN          0.908
ARABIA           0.927
SINGAPORE        0.941
THAILAND         0.957
US               0.865
VIETNAM          1.315
ROW              0.805 ;

PARAMETER
PRODUCTION(R)     TOTAL PRODUCTION OF GOODS
PRODUCTIONT(R)    TOTAL PRODUCTION OF TRADABLE GOODS
PRODUCTIONNT(R)   TOTAL PRODUCTION OF NONTRADABLE GOODS
EXPORT(R)         TOTAL EXPORT OF ONE COUNTRY
IMPORT(R)         TOTAL IMPORT OF ONE COUNTRY
TRADE(R)          TOTAL TRADE OF ONE COUNTRY
UTILITY(R)        TOTAL UTILITY OF ONE COUNTRY
EMPLOYMENT(R)     EXPLOYMENT IN TRADABLE SECTORS
BALANCE(R)        TRADE IMBALANCE
EV(R)             EQUIVALEND VARIATION
CV(R)             COMPENSATION VARIATION

CPRODUCTION       PERCENT CHANGE OF TOTAL PRODUCTION
CPRODUCTIONT(R)   PERCENT CHANGE OF TRADABLE PRODUCTION
CPRODUCTIONNT(R)  PERCENT CHANGE OF NONTRADABLE PRODUCTION

CEXPORT(R)        PERCENT CHANGE OF TOTAL EXPORT FOR ONE COUNTRY
CIMPORT(R)        PERCENT CHANGE OF TOTAL IMPORT OF ONE COUNTRY
CTRADE(R)         PERCENT CHANGE OF TOTAL TRADE OF ONE COUNTRY
CBALANCE(R)       PERCENT CHANGE OF TRADE IMBALANCE
CUTILITY(R)       PERCENT CHANGE OF UTILITY OF ONE COUNTRY
CEMPLOYMENT(R)    PERCENT CHANGE OF EMPLOYMENT IN TRADABLE SECTOR
EVGDP(R)          EV AS SHARE OF GDP
CVGDP(R)          CV AS SHARE OF GDP

WUTILITY          PERCENT CHANGE OF WORLD UTILITY
WPRODUCTION       PERCENT CHANGE OF WORLD PRODUCTION
WPRODUCTIONT
WPRODUCTIONNT
WMANUFACTURE      PERCENT CHANGE OF MANUFACTURE SECTOR
WNONMANUFACTURE   PERCENT CHANGE OF NONMANUFACTURE SECTOR
WEMPLOYMENT       PERCENT CHANGE OF WORLD EMPLOYMENT
WTRADE            PERCENT CHANGE OF WORLD TRADE
WEXPORT           PERCENT CHANGE OF WORLD EXPORT
WIMPORT           PERCENT CHANGE OF WORLD IMPORT
;


PRODUCTION(R) = SUM(GG,PRN.L(R,GG)*P.L(R,GG));
PRODUCTIONT(R) = PRN.L(R,"TRADABLE")*P.L(R,"TRADABLE");
PRODUCTIONNT(R) = PRN.L(R,"NONTRADABLE")*P.L(R,"NONTRADABLE");

EXPORT(R) =  SUM(RR,GDEM.L(RR,R)*P.L(R,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
IMPORT(R) =  SUM(RR,GDEM.L(R,RR)*P.L(RR,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
TRADE(R) = EXPORT(R)+IMPORT(R);
BALANCE(R) = EXPORT(R)-IMPORT(R);
UTILITY(R) = INC.L(R)*(SHARE1(R)*(PM.L(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN.L(R)**
(1-ELASC1(R)))) **(1/(ELASC1(R)-1));
EMPLOYMENT(R) = FACDEM.L(R,"TRADABLE","L");
EV(R) = (SUM(RR,GDEM.L(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM0(R));;
CV(R )= (SUM(RR,GDEM.L(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM0(R));

CEXPORT(R) = (EXPORT(R)-EXPORT0(R))*100/EXPORT0(R);
CIMPORT(R) = (IMPORT(R)-IMPORT0(R))*100/IMPORT0(R);
CTRADE(R) = (TRADE(R)-TRADE0(R))*100/TRADE0(R);
CBALANCE(R) = (BALANCE(R)-BALANCE0(R))*100/BALANCE0(R);

CPRODUCTION(R) = (PRODUCTION(R)-PRODUCTION0(R))*100/PRODUCTION0(R);
CPRODUCTIONT(R) = (PRODUCTIONT(R)-PRODUCTIONT0(R))*100/PRODUCTIONT0(R);
CPRODUCTIONNT(R) = (PRODUCTIONNT(R)-PRODUCTIONNT0(R))*100/PRODUCTIONNT0(R);


CUTILITY(R) = (UTILITY(R)-UTILITY0(R))*100/UTILITY0(R);
CEMPLOYMENT(R) = (EMPLOYMENT(R)-EMPLOYMENT0(R))*100/EMPLOYMENT0(R);
EVGDP(R) = EV(R)*100/PRODUCTION(R);
CVGDP(R) = CV(R)*100/PRODUCTION(R);

WUTILITY = (SUM(R,UTILITY(R))-SUM(R,UTILITY0(R)))*100/SUM(R,UTILITY0(R));
WPRODUCTION = (SUM(R,PRODUCTION(R))-SUM(R,PRODUCTION0(R)))*100/SUM(R,PRODUCTION0(R));
WPRODUCTIONT = (SUM(R,PRODUCTIONT(R))-SUM(R,PRODUCTIONT0(R)))*100/SUM(R,PRODUCTIONT0(R));
WPRODUCTIONNT = (SUM(R,PRODUCTIONNT(R))-SUM(R,PRODUCTIONNT0(R)))*100/SUM(R,PRODUCTIONNT0(R));

WEMPLOYMENT = (SUM(R,EMPLOYMENT(R))-SUM(R,EMPLOYMENT0(R)))*100/SUM(R,EMPLOYMENT0(R));
WTRADE = (SUM(R,TRADE(R))-SUM(R,TRADE0(R)))*100/SUM(R,TRADE0(R));
WEXPORT = (SUM(R,EXPORT(R))-SUM(R,EXPORT0(R)))*100/SUM(R,EXPORT0(R));
WIMPORT = (SUM(R,IMPORT(R))-SUM(R,IMPORT0(R)))*100/SUM(R,IMPORT0(R));


DISPLAY CUTILITY,CPRODUCTION,CPRODUCTIONT,CPRODUCTIONNT,CEMPLOYMENT,CEXPORT,CIMPORT,CTRADE,CBALANCE,CVGDP,EVGDP
WUTILITY,WPRODUCTION,WPRODUCTIONT,WPRODUCTIONNT,WEMPLOYMENT,WTRADE,WEXPORT,WIMPORT;
